add_portrait("Moravator Captain", "captain.png", 0);
add_portrait("Scientist on Zebulon", "scientist2.png", 0);
add_portrait("Admiral Vadas", "admiral_vadas.png", 0);
add_portrait("Engineering Team Leader", "scientist1.png", 0);

cut_scene_on();
foreach(squad in my_squads) {
	type = squad.get_type();
	if (type == 2 || type == 3)
		squad.select();
}
local moon_pos = side_3_squads[0].get_pos();
order_move(moon_pos[0], moon_pos[1]);

wait(30);

set_portrait("Moravator Captain");
portrait_text("Making final approach to Zebulon now, Admiral.", "test.ogg");
wait_for_portrait();

wait(60);
set_viewpoint(19652, 19367);
set_portrait("Scientist on Zebulon");
portrait_text("Good day, Admiral! Not that we really have days and nights here, the nebula blocks out nearly all the light from this system's sun.", "good_day.ogg");
wait_for_portrait();

set_portrait("Scientist on Zebulon");
portrait_text("But the amount of ionized dephalium we have detected below the moon's surface is quite extraordinary. We must start work as soon as possible.", "but_the.ogg");
wait_for_portrait();

local player_cap_pos = my_squads[0].get_pos();
set_viewpoint(player_cap_pos[0] - 600, player_cap_pos[1] - 600);
cut_scene_off();

wait(450);

set_viewpoint(19652, 19367);
set_portrait("Scientist on Zebulon");
portrait_text("Admiral, we have picked up more ships on our long range sensors, coming from the other side of the nebula. Are they your scouts?", "admiral_we_have.ogg");
wait_for_portrait();

player_cap_pos = my_squads[0].get_pos();
set_viewpoint(player_cap_pos[0] - 600, player_cap_pos[1] - 600);
set_portrait("Admiral Vadas");
portrait_text("Nothing to do with us. Are you sure it isn't the nebula interfering with your equipment?", "test.ogg");
wait_for_portrait();

wait_for_task("bombers_coming_in", -1);
cut_scene_on();
set_viewpoint(19652, 19367);

wait(60);
set_portrait("Scientist on Zebulon");
portrait_text("We are under attack by Artilian ships! Please help us!", "we_are_under.ogg");
wait_for_portrait();

//this will be the research team
wait_for_task("all_big_ships_dead", -1);

portrait_text("Aargh!", "aargh.ogg");
wait_for_portrait();

wait(30);

cut_scene_off();
player_cap_pos = my_squads[0].get_pos();
set_viewpoint(player_cap_pos[0] - 600, player_cap_pos[1] - 600);
set_portrait("Admiral Vadas");
portrait_text("Man battlestations! Launch small ships! They will soon see just how foolish an action that was.", "test.ogg");
wait_for_portrait();

set_portrait("Admiral Vadas");
portrait_text("We cannot allow any more science vessels to be destroyed! Protect the remaining science vessels at all costs!", "test.ogg");

while (true) {
	wait(-1);
	if (wakeup_reason() == "custom_ai_task_0")
		player_failed_mission("At least two science vessels must survive");
	//only care about Artilians
	else if (which_side_dead() == 4)
		break;
}
mission_complete();

wait(120);

set_portrait("Moravator Captain");
portrait_text("Seems that was the last of them.", "test.ogg");
wait_for_portrait();

wait(30);

set_portrait("Engineering Team Leader");
portrait_text("Well, we must be getting on. Admiral, can we begin setting down our equipment and engineers on Zebulon's surface?", "test.ogg");
wait_for_portrait();

set_portrait("Admiral Vadas");
portrait_text("Certainly, you have the use of any men or resources that you need. It is vital to begin mining that fuel as soon as possible.", "test.ogg");
wait_for_portrait();

set_portrait("Engineering Team Leader");
portrait_text("Thank you Admiral, we will start work right away.", "test.ogg");
wait_for_portrait();

wait(150);
end_mission();
